capture log close
clear all
macro drop _all
*version 18
cd "C:\Users\alice\OneDrive\Alice QUANTONOMICS\Input substitution\Stata\3. Opex Cost Function\Data Mgt"
set more off
log using Output/log/m_DNSPopex24_inputsubt, replace text
*set scheme vg_s1c

/*--------------------------------------------------------------------------
Project: Quantonomics DNSP Opex Cost Function - Input Substitution Project
Author:  Alice Giovani 
File:    m_DNSPopex24_inputsubt.do
Initial Date:    3-Jul-2022
Revised Date:	 01-May-2025
--------------------------------------------------------------------------*/

tempfile nz ontario

* A. New Zealand DNSPs
*--------------------------------------------------------------------------

import excel "Input/Quantonomics-AER-NZData-29Aug2024", clear ///
	sheet("NZ-DisclosureData") cellrange(A1:N343) firstrow case(l)
sort eiid year	
describe, fullnames

rename opex000 opex
rename ratchetedmaximumdemandmw rmdem
rename customernumbers custnum
rename circuitlengthkm circlen
rename shareofundergroundcables shareugc
rename priceopexindex propex
rename yrmd ten_yrs_rmd

drop maximumcoincidentsystemdemand undergroundlengthkm maximumdemandmw
order eiid dnspname year country opex propex rmdem custnum circlen shareugc
*tabmiss
describe

save `nz'
export excel "Output/xlsx/OpexFnData.xlsx", firstrow(var) keepcellfmt sheet("nz", replace)

* B. Ontario
*--------------------------------------------------------------------------

import excel "Input/Ontario ABR24 Data - 29Aug2024", clear ///
	sheet("Ontario ABR24") cellrange(A1:N523) firstrow case(l)
sort eiid year	
describe, fullnames

rename rmdemand rmdem
rename propoex propex
drop uglen maxdem energykwh
rename yrmd ten_yrs_rmd

replace dnspname = "Entegrus Powerlines" if dnspname == "Entegrus Powerlines Inc."

*tabmiss
describe

save `ontario'
export excel "Output/xlsx/OpexFnData.xlsx", firstrow(var) keepcellfmt sheet("ont", replace)

* C. Australia & append
*--------------------------------------------------------------------------

import excel "Input/Australia ABR24 Data - 11Sep2024", clear ///
	sheet("Sheet1") cellrange(A1:L235) firstrow case(l)
sort eiid year	
describe, fullnames

drop maxdemand
	
* D. Append
*-----------------------------------------------------
	
append using `nz' `ontario'
sort eiid year

replace shareugc = 0.01 if shareugc < 0.01
label define country 1 "1.Aust" 2 "2.NZ" 3 "3.Ontario"
label values country country
labmask eiid, values(dnspname)	
drop dnspname

label variable opex  			"Operating expenditure (local currency, 000)"
label variable custnum			"Customers (#)"
label variable circlen			"Circuit length (km)"
label variable shareugc			"Underground cable: % of circuit length"
label variable rmdem 			"Ratcheted maximum demand (MW)"
label variable propex			"Opex price index (2005 = 1.0)"
label variable country			"Country code"
label variable eiid				"Utility code"
label variable year				"Reporting year"

tab1 country eiid
describe
summarize 
*tabmiss

save Output/dta/DNSPopex24_InputSubs, replace

merge 1:1 eiid year using input/capitalprice.dta

keep eiid year country opex propex rmdem custnum circlen shareugc ten_yrs_rmd ///
ratioprice 

save Output/dta/DNSPopex24_InputSubs, replace


*gen diff = rmdem - ten_yrs_rmd

log close
exit

